#include "ByteMunger.h"

ushort		GetRboShort(RboShort rShort)
{
	return (
		(((ushort)rShort.high) << 8) 
		|((ushort)rShort.low)
	);
}

RboShort	SetRboShort(ushort value)
{
	RboShort	rShort;
	
	rShort.high = (value >> 8);
	rShort.low	= value & 0x00FF;	
	return rShort;
}

ulong		GetRbo3Bytes(Rbo3Byte r3)
{
	return (
			(((ulong)r3.high) << 16) 
		| 	(((ulong)r3.med) << 8) 
		| 	 ((ulong)r3.low)
	);
}

Rbo3Byte		SetRbo3Bytes(ulong value)
{
	Rbo3Byte	r3Byte;
	
	r3Byte.high = (value & 0xFF0000) >> 16;
	r3Byte.med	= (value & 0x00FF00) >> 8;
	r3Byte.low	= (value & 0x0000FF);
	return r3Byte;
}

ulong		GetRboLong(Rbo4Byte r4)
{
	Rbo4Byte	value;
	
	value = SetRboLong(*(ulong *)&r4);
	return *(ulong *)&value;
}

Rbo4Byte		SetRboLong(ulong value)
{
	Rbo4Byte	r3Byte;

	r3Byte.high		= (value & 0xFF000000) >> 24;
	r3Byte.med_high = (value & 0x00FF0000) >> 16;
	r3Byte.med_low	= (value & 0x0000FF00) >> 8;
	r3Byte.low		= (value & 0x000000FF);
	return r3Byte;
}
